<?php include 'db.php'; ?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;700&display=swap" rel="stylesheet">
    <style>body { font-family: 'Hind Siliguri', sans-serif; }</style>
    <title>Al-Ummah | আল-উম্মাহ</title>
</head>
<body class="bg-gray-100 text-gray-900">
    <nav class="bg-emerald-800 text-white py-4 shadow-lg sticky top-0 z-50">
        <div class="container mx-auto px-4 flex justify-between items-center">
            <h1 class="text-3xl font-bold tracking-wider">আল-উম্মাহ</h1>
            <a href="login.php" class="hover:underline">অ্যাডমিন লগইন</a>
        </div>
    </nav>

    <div class="container mx-auto px-4 py-12">
        <h2 class="text-3xl font-bold text-center mb-10 text-emerald-900">আমাদের প্রকাশিত বইসমূহ</h2>
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-8">
            <?php
            $result = mysqli_query($conn, "SELECT * FROM books ORDER BY upload_date DESC");
            while($row = mysqli_fetch_assoc($result)) {
                echo '
                <div class="bg-white rounded-2xl shadow-md hover:shadow-2xl transition duration-300 transform hover:-translate-y-2 overflow-hidden border border-gray-200">
                    <img src="uploads/covers/'.$row['cover_image'].'" class="w-full h-80 object-cover">
                    <div class="p-6">
                        <p class="text-xs text-emerald-600 font-bold mb-1">প্রকাশকাল: '.$row['upload_date'].'</p>
                        <h3 class="text-xl font-bold mb-4 h-14 overflow-hidden">'.$row['title'].'</h3>
                        <a href="uploads/pdfs/'.$row['pdf_file'].'" target="_blank" class="block w-full text-center bg-emerald-600 text-white py-3 rounded-xl font-semibold hover:bg-emerald-700 transition">অনলাইনে পড়ুন</a>
                    </div>
                </div>';
            }
            ?>
        </div>
    </div>
</body>
</html>